/*-------------------------------------*\
|   AVR SPI Color LCD Display			|
| Provides access to LCD				|
| using software SPI in assembly		|
| Adam Honse (CalcProgrammer1), 11/2010 |
\*-------------------------------------*/

#include "color_lcd.h"

void soft_spi_init()
{
	DDRD |= 0xE0;
	PORTD |= 0xE0;
}


void soft_spi_send_byte(char cmd, char data)
{
	// enable chip_sel
	asm("cbi %0, 7" : : "I" (_SFR_IO_ADDR(PORTD)));
	
	// Send the command flag bit
	asm("cbi %0, 5" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("cbi %0, 6" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("sbrc %0, 0" : : "a" (cmd));
	asm("sbi %0, 5" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("sbi %0, 6" : : "I" (_SFR_IO_ADDR(PORTD)));
	
	// Send Bit 7 of data
	asm("cbi %0, 5" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("cbi %0, 6" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("sbrc %0, 7" : : "a" (data));
	asm("sbi %0, 5" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("sbi %0, 6" : : "I" (_SFR_IO_ADDR(PORTD)));
	
	// Send Bit 6 of data
	asm("cbi %0, 5" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("cbi %0, 6" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("sbrc %0, 6" : : "a" (data));
	asm("sbi %0, 5" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("sbi %0, 6" : : "I" (_SFR_IO_ADDR(PORTD)));
	
	// Send bit 5 of data
	asm("cbi %0, 5" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("cbi %0, 6" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("sbrc %0, 5" : : "a" (data));
	asm("sbi %0, 5" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("sbi %0, 6" : : "I" (_SFR_IO_ADDR(PORTD)));
	
	// Send bit 4 of data
	asm("cbi %0, 5" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("cbi %0, 6" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("sbrc %0, 4" : : "a" (data));
	asm("sbi %0, 5" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("sbi %0, 6" : : "I" (_SFR_IO_ADDR(PORTD)));
	
	// Send bit 3 of data
	asm("cbi %0, 5" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("cbi %0, 6" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("sbrc %0, 3" : : "a" (data));
	asm("sbi %0, 5" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("sbi %0, 6" : : "I" (_SFR_IO_ADDR(PORTD)));
	
	// Send bit 2 of data
	asm("cbi %0, 5" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("cbi %0, 6" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("sbrc %0, 2" : : "a" (data));
	asm("sbi %0, 5" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("sbi %0, 6" : : "I" (_SFR_IO_ADDR(PORTD)));
	
	// Send bit 1 of data
	asm("cbi %0, 5" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("cbi %0, 6" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("sbrc %0, 1" : : "a" (data));
	asm("sbi %0, 5" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("sbi %0, 6" : : "I" (_SFR_IO_ADDR(PORTD)));
		
	// Send bit 0 of data
	asm("cbi %0, 5" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("cbi %0, 6" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("sbrc %0, 0" : : "a" (data));
	asm("sbi %0, 5" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("sbi %0, 6" : : "I" (_SFR_IO_ADDR(PORTD)));
	
	// disable chip_sel
	asm("sbi %0, 7" : : "I" (_SFR_IO_ADDR(PORTD)));
}

void color_lcd_initialize()
{
	//Set Reset Line as Output
	DDRB |= 0b00000001;

	//Initialize the Software SPI Output
	soft_spi_init();


	//Reset the LCD

	asm("cbi %0, 6" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("cbi %0, 5" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("sbi %0, 7" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("cbi %0, 0" : : "I" (_SFR_IO_ADDR(PORTB)));
	_delay_ms(100);
	asm("sbi %0, 0" : : "I" (_SFR_IO_ADDR(PORTB)));
	_delay_ms(100);
	asm("sbi %0, 6" : : "I" (_SFR_IO_ADDR(PORTD)));
	asm("sbi %0, 5" : : "I" (_SFR_IO_ADDR(PORTD)));


	//Send Initialization Commands

	//Exit sleep mode
	color_lcd_send_cmd(SLEEPOUT);
	
	//Turn on voltage booster
	color_lcd_send_cmd(BSTRON);

	//Set color mode to 0x03 (12-bit)
	color_lcd_send_cmd(COLMOD);
	color_lcd_send_data(0x03);

	//Set memory access
	color_lcd_send_cmd(MADCTL);
	color_lcd_send_data(0x00);

	//Set contrast to 0x42
	color_lcd_send_cmd(SETCON);
	color_lcd_send_data(0x42);

	//Turn on display
	color_lcd_send_cmd(DISPON);
}

void color_lcd_set_pixel(int color, unsigned char x, unsigned char y)
{
	color_lcd_send_cmd(PASET);
	color_lcd_send_data(y);
	color_lcd_send_data(y);

	color_lcd_send_cmd(CASET);
	color_lcd_send_data(x);
	color_lcd_send_data(x);

	color_lcd_send_cmd(RAMWR);

	color_lcd_send_data(color>>4);
	color_lcd_send_data(color<<4);
}

void color_lcd_draw_rectangle(int color, unsigned char xs, unsigned char ys, unsigned char xe, unsigned char ye)
{
	color_lcd_send_cmd(PASET);
	color_lcd_send_data(ys);
	color_lcd_send_data(ye);

	color_lcd_send_cmd(CASET);
	color_lcd_send_data(xs);
	color_lcd_send_data(xe);

	color_lcd_send_cmd(RAMWR);

	unsigned int half_rect_area = (((unsigned int)(xe-xs+1)*(ye-ys+1))/2);

	for(unsigned int i = 0; i < half_rect_area; i++)
	{
		color_lcd_send_data(color>>4);
		color_lcd_send_data(((color&0x0F)<<4)|(color>>8));
		color_lcd_send_data(color);
	}
}
